*! version 4.0
* 30 May 2021
* NIDS-CRAM
* Merging NIDS Wave 5 to any given wave of NIDS-CRAM

/*----------------------------------------------------
NOTE TO USER
This do file merges all the individual level and household level datasets from Wave 5 of NIDS with any given wave of NIDS-CRAM. 
NIDS data files can be found here: https://www.datafirst.uct.ac.za/dataportal/index.php/catalog/NIDS/about

Note: 
1. NIDS variables are prefaced with the wave number "w5", while NIDS-CRAM wave `i' variables are prefaced with "w`i'_nc". Where `i' is the wave number.
2. The roster record from NIDS Wave 5 that is merged in is only for the house where the respondent was a resident member during NIDS Wave 5.

* NB
This do file does not create a balanced panel dataset and as such the interview outcomes need to be taken into account when performing analysis.

This do file assumes a parent folder (defined as global DataIN below) that contains separate subfolders for each NIDS-CRAM wave, 
and a seperate folder for NIDS Wave 5 called "NIDS Wave 5" 

The sub-folder structure should look as follows:  
* NIDS Wave 5
* Wave `i'          - where `i' is the wave number; E.g. "Wave 1"


*/
 
*===========================================================================================================================================
* GLOBALS FOR DATA FILES AND VERSION SUFFIXES

global DataIN "C:\Users\NIDS-CRAM_Data" 						//File path to where data is located. Change this path according to where your data folder is located on your computer.
global NC_WAVE = 5												// Number of the NIDS-CRAM wave to be merged in.

cd "$DataIN"

*===========================================================================================================================================

clear all
set more off
set maxvar 20000 

// Appending individual level data files from NIDS Wave 5 and merging to the household level data files. 
// NIDS-CRAM does not have separate household and individual sub-datasets, so it is more 
// straightforward to merge NIDS-CRAM with the NIDS data once the latter is all merged together. 

*--------------------------------------------------------------------------------------------------
* MERGING NIDS WAVE 5 TOGETHER
*--------------------------------------------------------------------------------------------------

* deriving the dataset version from the dataset file name
global VersionIN: dir "$DataIN\NIDS Wave 5" files "Adult*.dta", respectcase
global VersionIN = subinstr($VersionIN,"Adult_W5_","",.)
global VersionIN = subinstr("$VersionIN",".dta","",.)

* appending the individual datasets
use "$DataIN\NIDS Wave 5\Adult_W5_$VersionIN.dta"
append using "$DataIN\NIDS Wave 5\Child_W5_$VersionIN.dta" "$DataIN\NIDS Wave 5\Proxy_W5_$VersionIN.dta"

* merging in the HH Roster
merge 1:1 pid w5_hhid using "$DataIN\NIDS Wave 5\HouseholdRoster_W5_$VersionIN.dta" 
drop if _merge==2
drop _merge

* merging in the HHQuestionnaire
merge m:1 w5_hhid using "NIDS Wave 5\HHQuestionnaire_W5_$VersionIN.dta"
drop if _merge!=3
drop _merge

* merging in the hhderived
merge m:1 w5_hhid using "$DataIN\NIDS Wave 5\hhderived_W5_$VersionIN.dta"
drop if _merge!=3
drop _merge

* merging in the indderived
merge 1:1 pid using "$DataIN\NIDS Wave 5\indderived_W5_$VersionIN.dta"
drop if _merge!=3
drop _merge
save wave5_merged, replace

*--------------------------------------------------------------------------------------------------
* MERGING NIDS-CRAM WAVE TOGETHER
*--------------------------------------------------------------------------------------------------

* deriving the dataset version from the dataset file name
global VersionIN: dir "$DataIN\Wave $NC_WAVE" files "NIDS-CRAM*.dta", respectcase
global VersionIN: subinstr global VersionIN ".dta" "",all
global VersionIN: subinstr global VersionIN "NIDS-CRAM_" "",all
global VersionIN: subinstr global VersionIN `"""' "",all

* merging NIDS-CRAM and derived data files
use "$DataIN\Wave $NC_WAVE\NIDS-CRAM_$VersionIN.dta", clear
merge 1:1 pid using "$DataIN\Wave $NC_WAVE\derived_NIDS-CRAM_$VersionIN.dta"
drop if _merge!=3
drop _merge

* merging in the Link file
merge 1:1 pid using "$DataIN\Wave $NC_WAVE\Link_File_NIDS-CRAM_$VersionIN.dta"
drop if _merge!=3
drop _merge

save nc_merged, replace

*--------------------------------------------------------------------------------------------------
* MERGING NIDS WAVE 5 & THE NIDS-CRAM WAVE TOGETHER
*--------------------------------------------------------------------------------------------------

use wave5_merged, clear
merge 1:1 pid using nc_merged
drop if _merge!=3
drop _merge
save nids_w5_nids-cram_w$NC_WAVE, replace 

*===========================================================================================================================================

erase nc_merged.dta
erase wave5_merged.dta

*===========================================================================================================================================

*THE END
